﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/OneColumn.master" CodeBehind="ActivityGantt.aspx.cs" Inherits="GUI.Pages.ActivityGantt" %>

<%@ Register TagPrefix="cc1" Namespace="Telerik.Web.UI.Gantt" Assembly="Telerik.Web.UI" %>

<asp:Content ID="Content1" ContentPlaceHolderID="Content" runat="server" >
   <div class="page-full-main-content">
       <asp:HiddenField ID="hdnOrdNum" runat="server" />   
        <div class="row">
            <div class="col-md-12 col-sm-12">
            <div class="portlet light bordered light-blue">
                    <div class="portlet-title">
                        <div class="caption">
                            <span class="caption-subject bold font-dark uppercase" id="pageTitle" runat="server"> <asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProjectManagementUI, Gantt_Title %>" /> </span>
                        </div>
                    </div>
                    <div class="portlet-body form">
                        <div class="form-actions right">
                            <asp:Button  OnClick="btnReorder_Click"  Visible="false" runat="server" ID="btnReorder"  CssClass="radius button left"  Text="<%$ Resources:ProjectManagementUI, Gantt_reorderfl %>" CausesValidation="false"/>
                            <asp:Button  OnClick="btnNew_Click" runat="server" ID="btnNew"  CssClass="btn red"  Text="<%$ Resources:ProjectManagementUI, UI_NewActivity %>" CausesValidation="false"/>
                            <asp:Button  OnClick="btnListView_Click" runat="server" ID="btnListView" CssClass="btn blue" CausesValidation="false" Text="<%$ Resources:ProjectManagementUI, UI_ListView %>"/>
                            <asp:Button  OnClick="btnUpdate_Click" runat="server" ID="Button1" CssClass="radius button right" CausesValidation="false" style="display:none" />
                        </div>

                        <div id="kendo-gantt" class="form-body">

                                    <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server" EnableAJAX="true" 
                                            LoadingPanelID="RadAjaxLoadingPanel1">
                                
                                      <telerik:RadGantt RenderMode="Lightweight" ID="RadGantt1" runat="server"  SelectedView="MonthView" CurrentTimeMarkerInterval="5000" BackColor="#ecf0f1" ForeColor="Black" Skin="Bootstrap"
                                            EnablePdfExport="True" AutoGenerateColumns="False" AllowDependencyDelete="False" AllowDependencyInsert="False" AllowTaskMove="False" EnableTheming="True" YearView-UserSelectable="True" BorderStyle="Dotted" AllowPercentCompleteDrag="False" AllowSorting="False" AllowTaskDelete="False" AllowTaskInsert="False" AllowTaskUpdate="False" type="display" EnableResources="True" AllowColumnResize="True" AllowTaskReorder="False" AllowTaskResize="False">
    
                                                   <Columns>
                                                        <telerik:GanttBoundColumn DataField="OrdinalNumber" Width="80px" HeaderText="<%$ Resources:ProjectManagementUI, Gantt_OrdinalNumber %>" DataType="String" UniqueName="OrdinalNumber" AllowEdit="False" AllowSorting="False"></telerik:GanttBoundColumn>
                                                        <telerik:GanttBoundColumn DataField="Title" Width="80px" HeaderText="<%$ Resources:ProjectManagementUI, Gantt_Task %>" AllowEdit="False" AllowSorting="False"></telerik:GanttBoundColumn>
                                                        <telerik:GanttBoundColumn DataField="Start" Width="80px" HeaderText="<%$ Resources:ProjectManagementUI, Gantt_Start %>" AllowEdit="False" AllowSorting="False" DataType="DateTime" DataFormatString="dd/MM/yy"></telerik:GanttBoundColumn>
                                                        <telerik:GanttBoundColumn DataField="End" Width="80px" HeaderText="<%$ Resources:ProjectManagementUI, Gantt_End %>" AllowEdit="False" AllowSorting="False" DataType="DateTime" DataFormatString="dd/MM/yy"></telerik:GanttBoundColumn>
                                                        <telerik:GanttBoundColumn DataField="PercentComplete" Width="80px" HeaderText="<%$ Resources:ProjectManagementUI, Gantt_Progress %>" AllowEdit="False" AllowSorting="False"></telerik:GanttBoundColumn>
                                                         <%--<telerik:GanttBoundColumn DataField="Description"  HeaderText="<%$ Resources:ProjectManagementUI, Gantt_Description %>" DataType="String" UniqueName="Description" AllowEdit="False" AllowSorting="False"></telerik:GanttBoundColumn>--%>
                                                         <%--<telerik:GanttBoundColumn DataField="Assigned"  HeaderText="<%$ Resources:ProjectManagementUI, Gantt_Assigned %>" DataType="String" UniqueName="Assigned" AllowEdit="False" AllowSorting="False"></telerik:GanttBoundColumn>--%>
                                                         <telerik:GanttResourceColumn HeaderText="<%$ Resources:ProjectManagementUI, Gantt_Assigned_Resources %>" Width="80px"></telerik:GanttResourceColumn>
                                                 </Columns>
                                             <DataBindings>
       
                                             </DataBindings>   
                                                      <CustomTaskFields>
                                                          <telerik:GanttCustomField PropertyName="OrdinalNumber" ClientPropertyName="ordinalNumber"  Type="String" />
                                                          <telerik:GanttCustomField PropertyName="Description" ClientPropertyName="description"  Type="String" />
                                                          <telerik:GanttCustomField PropertyName="Assigned" ClientPropertyName="assigned"  Type="String" />
                                                      </CustomTaskFields>

                                            <DayView HourSpan="1" SlotWidth="100px"></DayView>

                                            <WeekView SlotWidth="100px"></WeekView>

                                            <MonthView SlotWidth="100px"></MonthView>

                                            <YearView SlotWidth="100px"></YearView>


                                            </telerik:RadGantt> 

                                </telerik:RadAjaxPanel>

                                <telerik:RadAjaxLoadingPanel runat="server" ID="RadAjaxLoadingPanel1" ClientIDMode="Static">
                                    <div class="updatePanelProgress">
                                        <asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_PleaseWait %>" />...</div>
                                </telerik:RadAjaxLoadingPanel>
                                <telerik:RadWindowManager Skin="Bootstrap"
                                  Behaviors="Close" ID="RadWindowManager1" 
                                   Opacity="50" runat="server" Width="1600" Height="680" >
                                    <Windows>
                                        <telerik:RadWindow ID="RadWindow1" Opacity="100" Width="1600" Height="480" Title="<%$ Resources:ProjectManagementUI, Common_Activity %>" runat="server" CssClass="task-window" EnableViewState = "false" OnClientClose="RefreshParentPage">
                                    
                                        </telerik:RadWindow>
                                     </Windows>
                                </telerik:RadWindowManager>

                        </div>

                        <div class="form-actions right">
                             <asp:Button  OnClick="btnReorder_Click" Visible="false" runat="server" ID="btnReorder1"  CssClass="radius button left"  Text="<%$ Resources:ProjectManagementUI, Gantt_reorderfl %>" CausesValidation="false"/>
                             <asp:Button  OnClick="btnNew_Click" runat="server" ID="btnNew1"  CssClass="btn red"  Text="<%$ Resources:ProjectManagementUI, UI_NewActivity %>" CausesValidation="false"/>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        var $ = $telerik.$;


        function eventHandler() {

            $("#MainContentPlaceHolder_Content_Button1").click();

        }

        $(document).on('click', '.radGrid', function (e) {
            var $element = $(e.target);
            $element = $element.parents("td[role = 'gridcell']").first();;
            var indeks = $element.index();
            if (indeks === 0) {
                var tas = $element.text();
                var ordnumber = document.getElementById('MainContentPlaceHolder_Content_hdnOrdNum');
                ordnumber.value = tas;
                var radwindow = document.getElementById('ctl00_ctl00_MainContentPlaceHolder_Content_RadWindow1');
                var url = "../Pages/GanttActivity.aspx?ordnumb=" + tas;
                radwindow.setAttribute("NavigateUrl", url);
                eventHandler();

            }
        });
        $(document).on('mouseover', '.radGrid', function (e) {
            var $element = $(e.target);
            $element = $element.parents("td[role = 'gridcell']").first();;
            var indeks = $element.index();
            if (indeks === 0) {
                var tas = $element.text();
                $element.prop("style", "background-color:#2980b9;cursor:pointer;");
            }
        });
        $(document).on('mouseout', '.radGrid', function (e) {
            var $element = $(e.target);
            $element = $element.parents("td[role = 'gridcell']").first();;
            var indeks = $element.index();
            if (indeks === 0) {
                var tas = $element.text();
                $element.prop("style", "background-color:transparent;cursor:pointer;");
            }

        });
          //dodano

          //PROVJERITI OVO
        $(document).on('mouseover', '.radButton.rgtPdfButton', function (e) {
            $("span[aria-label]").css("float", "left");
            $("span[aria-label]").css("width", "fit-content");
           // $("span").css("float", "left");
           // $("span").css("width", "fit-content");
            $("td[role='gridcell']").css("width", "fit-content");
            $(".radGrid.rgtTreelist").css("width", "fit-content");
            $(".rgtTreelistWrapper").css("width", "fit-content");
            $("tr[role='row']").css("width", "fit-content");

            //$("body *").text(function () {
            //    $(this).text().replace("ž", "~");
            //    //alert($(this).text());
            //});
            //$("body *").text(function () {
            //    $(this).text().replace("&ccaron", "c");
            //});
        });
        //function replaceznake() {

        //    document.body.innerText.replace('Š', '&Scaron');
        //    document.body.innerText.replace('š', '&scaron');
        //    document.body.innerText.replace('Č', '&Ccaron');
        //    document.body.innerText.replace('č', '&ccaron');
        //    document.body.innerText.replace('Ć', '&Cacute');
        //    document.body.innerText.replace('ć', '&cacute');
        //    document.body.innerText.replace('Ž', '&Zcaron');
        //    document.body.innerText.replace('ž', '&zcaron');
        //    document.body.innerText.replace('Đ', '&Dstrok');
        //    document.body.innerText.replace('đ', '&dstrok');
        //}
        //dodano
        $(document).on('mouseout', '.radButton.rgtPdfButton', function (e) {
            $("tr[role='row']").css("width", "");
            $(".rgtTreelistWrapper").css("width", "30%");
            $(".radGrid.rgtTreelist").css("width", "");
            $("td[role='gridcell']").css("width", "");
            $("span").css("width", "");
            $("span").css("float", "");
            $("span[aria-label]").css("width", "");
            $("span[aria-label]").css("float", "");
            $(".rgtTTimelineWrapper").css("width", "70%")
            $(".rgtToolbar.rgtHeader").css("visibility", "visible")
        });
        $(document).on('click', '.radButton.rgtPdfButton', function (e) {
            var $element = $(e.target);
          $(".rgtToolbar.rgtHeader").css("visibility", "hidden")
        });
        function openRadWindow() {
            var manager = $.find('#ctl00_ctl00_MainContentPlaceHolder_Content_RadWindowManager1');
            var windows = $(manager).find('#ctl00_ctl00_MainContentPlaceHolder_Content_RadWindow1');
            var radwindow = windows[0];
            alert(radwindow.lenght);
            if (!radwindow.isVisible) {
                radwindow.isVisible = true;
                radwindow.center;
            }
            return false;
        }

        function RefreshParentPage() {
            var urla = document.location.href;
            var n = urla.indexOf('?');
            var newUrl = urla.substring(0, n);
            window.location.replace(newUrl);
        }
     </script>
</asp:Content>

